public class Student {
    private Name name;
    private String id;
    
    public Student() {
        // "this" is optional here.
        this.name = new Name();
        this.id = "";
    }
    
    public Student(Name name, String id) {
        // "this" is necessary here!
        this.name = name;
        this.id = id;
    }
    
    public Name getName() {
        // "this" is optional here; we've kept it in.
        return this.name;
    }
    public String getId() {
        // "this" is optional here; we've left it out.
        return id;
    }
    
    public void setName(String first, String last) {
        // "this" is optional here too.
        this.name = new Name(first, last);
    }
    public void setId(String id) {
        // "this" is necessary again here!
        this.id = id;
    }
    
    public static void main(String[] args) {
        // Test function for the Student class.
        Student someLearner = new Student();
        someLearner.setName("Micah", "Jackson");
        someLearner.setId("edu.carlton.hr.id31415927");
        System.out.format(
            "Hi %s, you are a Student, your full name is %s,\nand your ID is %s.\n",
            someLearner.getName().getFirstName(),
            someLearner.getName().getFullName(),
            someLearner.getId());
    }
}
