public class CollegeStudent extends Student {
    private int matriculationYear;
    private String department;
    private List<String> classes;
    
    public CollegeStudent() {
        super();
        matriculationYear = 0;
        department = "[undeclared]";
        classes = new MysteryListImplementation<String>();
    }
    
    public CollegeStudent(String firstName, String lastName, String id, int year) {
        super(new Name(firstName, lastName), id);
        matriculationYear = year;
        department = "[undeclared]";
        classes = new MysteryListImplementation<String>();
    }
    
    public void setMatriculationYear(int year) {
        this.matriculationYear = year;
    }
    public void declareMajor(String department) {
        this.department = department;
    }
    
    public void register(String classId) {
        this.classes.add(classId);
    }
    public boolean drop(String classId) {
        // First we have to find the index where this class is stored.
        // We declare i outside the loop so that it's still in scope after
        // the loop ends.
        int searchIndex;
        for(searchIndex = 0; searchIndex < classes.length(); searchIndex++) {
            if(classes.at(searchIndex).equals(classId)) {
                // We found it!
                break;
            }
        }
        if(searchIndex == classes.length()) {
            // We searched through the whole list and didn't find the class.
            return false;
        }
        classes.remove(searchIndex);
        return true;
    }
    public void dropAll() {
        classes.clear();
    }
    
    public void display() {
        System.out.format("%s (matr. %d)\nMajor: %s\nClasses:\n",
                          this.getName().getFullName(),
                          this.matriculationYear,
                          this.department);
        for(int i = 0; i < classes.length(); i++) {
            System.out.println(classes.at(i));
        }
    }
    
    
    public static void main(String[] args) {
        // Test function for the CollegeStudent class.
        
        // Tilda just joined Carleton!
        CollegeStudent someCarl = new CollegeStudent(
            "Tilda", "Notwist", "edu.carlton.hr.id31415927", 2013);
        
        // Now registration comes and...
        someCarl.register("HIST 100");
        someCarl.register("PSYC 110");
        someCarl.register("GEOL 110");
        // Hang on, CS rules.
        someCarl.drop("GEOL 110");
        someCarl.register("CS   111");
        
        System.out.println("\nFall term, first year:\n=============");
        someCarl.display();
        
        // Flash forward in time a little...
        someCarl.declareMajor("CS");
        someCarl.dropAll();
        someCarl.register("CS   202");
        someCarl.register("MATH 208");
        someCarl.register("PHIL 213");
        
        System.out.println("\n\nThe future, no doubt:\n=============");
        someCarl.display();
    }
}
